<?php
require_once __DIR__ . '/../services/facturamaService.php';
class InvoiceController {
  public function create() {
    $config = require __DIR__ . '/../config.php';
    $facturama = new FacturamaService($config);
    $params = $this->params;
    try {
      $facturama->params = $params;
      $result = $facturama->createCfdi40();
      if($result){
        $cfdiId = $result->Id;
        $facturama->cfdi_id     = $cfdiId;
        $facturama->cfdi_format = 'pdf';
        $pdf = $facturama->getCfdibyFormat();
        $facturama->cfdi_format = 'xml';
        $xml = $facturama->getCfdibyFormat();
        $pdf = $pdf->Content;
        $xml = $xml->Content;
        echo json_encode([
          'status' => 'success',
          'invoice_id' => $cfdiId,
          'pdf_base64' => $pdf,
          'xml_base64' => $xml
        ]);
      }else{
        echo json_encode([
          'status' => 'error',
          'message' => $result->message ?? 'Ocurrió un error al generar la factura'
        ]);
      }
    } catch (Exception $e) {
      http_response_code(500);
      echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
  }
  public function getCfdiByFormat() { // xml or pdf
    $config = require __DIR__ . '/../config.php';
    $facturama = new FacturamaService($config);
    try {
        $facturama->cfdi_id     = $this->cfdi_id;
        $facturama->cfdi_format = $this->cfdi_format;
        $result = $facturama->getCfdibyFormat();
        echo json_encode([
            'status' => 'success',
            'data' => $result->Content,
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
  }
  public function getCfdiAcuse() { //
    $config = require __DIR__ . '/../config.php';
    $facturama = new FacturamaService($config);
    try {
        $facturama->cfdi_id     = $this->cfdi_id;
        $result = $facturama->getCfdiAcuse();
        echo json_encode([
            'status' => 'success',
            'data' => $result->Content,
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'status' => 'error',
            'message' => $e->getMessage()
        ]);
    }
  }
  public function cancelCfdi() {
    $config = require __DIR__ . '/../config.php';
    $facturama = new FacturamaService($config);
      try {
          $facturama->cfdi_id = $this->cfdi_id;
          $facturama->params  = $this->params;
          $result             = $facturama->cancelCfdi();
          
          if($result->status == "error"){
            echo json_encode([
              'status' => 'error',
              'message' => $result->message,
            ]);
          }else{
            echo json_encode([
              'status' => 'success',
              'data' => $result->data
            ]);
          }
      } catch (Exception $e) {
          http_response_code(500);
          echo json_encode([
              'status' => 'error',
              'message' => $e->getMessage()
          ]);
      }
  }
}