<?php
require_once __DIR__ . '/../../vendor/autoload.php';
use Facturama\Client;
class FacturamaService {
  private $api;
  public function __construct($config) {
    $this->api = new \Facturama\Client($config['FACTURAMA_USER'], $config['FACTURAMA_PASS']);
  }
  public function getCatalog($type, $param = []) { 
    $localCatalogs = [
      'ieps_sat', 'isr_sat', 'iva_sat', 'imposed_object_sat', 'withholdings_iva_sat'
    ];
    if (in_array($type, $localCatalogs)) {
      $objService = new CatalogService();
      return $objService->getCatalog($type);
    }
    $endpoints = [
      'postal-code'     => 'catalogs/PostalCodes',
      'country'         => 'catalogs/Countries',
      'state'           => 'catalogs/States',
      'cfdi-use'        => 'catalogs/CfdiUses',
      'unit-code'       => 'catalogs/Units',
      'product'         => 'catalogs/ProductsOrServices',
      'currency'        => 'catalogs/currencies',
      'payment-form'    => 'catalogs/PaymentForms', 
      'payment-method'  => 'catalogs/PaymentMethods',
      'fiscal-regimen'  => 'catalogs/FiscalRegimens',
      'cfdi-type'       => 'catalogs/CfdiTypes',
      //'status'          => 'client/status',
      'federal-taxes'   => 'catalogs/FederalTaxes'
    ];
    if (!isset($endpoints[$type])) {
      throw new Exception("Catálogo '$type' no soportado.");
    }
    return $this->api->get($endpoints[$type], $param);
  }
}

class CatalogService{
    private $catalogs;

    public function __construct() { 
        $this->catalogs = [
            'ieps_sat' => [
                            ['id' => 1, 'title' => 'IEPS 300%',   'value' => '3.000000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 2, 'title' => 'IEPS 160%',   'value' => '1.600000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 3, 'title' => 'IEPS 53%',    'value' => '0.530000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 4, 'title' => 'IEPS 50%',    'value' => '0.500000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 5, 'title' => 'IEPS 35%',    'value' => '0.350000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 6, 'title' => 'IEPS 30.4%',  'value' => '0.304000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 7, 'title' => 'IEPS 30%',    'value' => '0.300000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 8, 'title' => 'IEPS 29.88%', 'value' => '0.298800',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 9, 'title' => 'IEPS 26.5%',  'value' => '0.265000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 10,'title' => 'IEPS 25%',    'value' => '0.250000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 11,'title' => 'IEPS 9%',     'value' => '0.090000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 12,'title' => 'IEPS 8%',     'value' => '0.080000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 13,'title' => 'IEPS 7%',     'value' => '0.070000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 14,'title' => 'IEPS 6%',     'value' => '0.060000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 15,'title' => 'IEPS 5.91%',  'value' => '0.059100',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 16,'title' => 'IEPS 4%',     'value' => '0.040000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1],
                            ['id' => 17,'title' => 'IEPS 3%',     'value' => '0.030000',  'created_at' => '2025-05-01', 'feature' => false, 'status' => 1]
            ],
            'isr_sat' => [
                            ['id' => 1,  'title' => 'ISR 20%',    'value' => '0.200000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 2,  'title' => 'ISR 10.666%','value' => '0.106660',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 3,  'title' => 'ISR 10%',    'value' => '0.100000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 4,  'title' => 'ISR 5.4%',   'value' => '0.054000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 5,  'title' => 'ISR 4%',     'value' => '0.040000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 6,  'title' => 'ISR 3%',     'value' => '0.030000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 7,  'title' => 'ISR 2.10%',  'value' => '0.021000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 8,  'title' => 'ISR 2%',     'value' => '0.020000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 9,  'title' => 'ISR 1.25%',  'value' => '0.012500',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 10, 'title' => 'ISR 1.1%',   'value' => '0.011000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 11, 'title' => 'ISR 1%',     'value' => '0.010000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 12, 'title' => 'ISR 0.9%',   'value' => '0.009000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 13, 'title' => 'ISR 0.5%',   'value' => '0.005000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 14, 'title' => 'ISR 0.4%',   'value' => '0.004000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 15, 'title' => 'ISR 0.1%',   'value' => '0.001000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                            ['id' => 16, 'title' => 'ISR 0%',     'value' => '0.000000',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1]
                          ],
            'iva_sat' => [
                            ['id' => 1, 'title' => 'IVA 16%', 'value' => '0.160000',  'created_at' => '2025-01-20', 'feature' => 0,  'status' => 1],
                            ['id' => 2, 'title' => 'IVA 8%',  'value' => '0.080000',  'created_at' => '2025-01-20', 'feature' => 0,  'status' => 1],
                            ['id' => 3, 'title' => 'IVA 0%',  'value' => '0.000000',  'created_at' => '2025-01-20', 'feature' => 0,  'status' => 1],
                            ['id' => 4, 'title' => 'EXCENTO', 'value' => '0.000000',  'created_at' => '2025-01-20', 'feature' => 0,  'status' => 1]
                          ],
            'imposed_object_sat' => [
                                      ['id' => 1, 'title' => '01 - No objeto de impuesto',                            'value' => '01',  'created_at' => '2025-01-20', 'feature' => 1,  'status' => 1],
                                      ['id' => 2, 'title' => '02 - Sí objeto de impuesto',                            'value' => '02',  'created_at' => '2025-01-20', 'feature' => 2,  'status' => 1],
                                      ['id' => 3, 'title' => '03 - Sí objeto del impuesto y no obligado al desglose', 'value' => '03',  'created_at' => '2025-01-20', 'feature' => 3,  'status' => 1],
                                      ['id' => 4, 'title' => '04 - Sí objeto del impuesto y no causa impuesto',       'value' => '04',  'created_at' => '2025-01-20', 'feature' => 4,  'status' => 1]
                                    ],
            'withholdings_iva_sat' => [
                                        ['id' => 1,  'title' => 'IVA Ret 16%',      'value' => '0.160000',  'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 2,  'title' => 'IVA Ret 10.6668%', 'value' => '0.106668',  'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 3,  'title' => 'IVA Ret 10.6667%', 'value' => '0.106667',  'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 4,  'title' => 'IVA Ret 10.6666%', 'value' => '0.106666',  'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 5,  'title' => 'IVA Ret 10.67%',   'value' => '0.1067',    'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 6,  'title' => 'IVA Ret 10.66%',   'value' => '0.1066',    'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 7,  'title' => 'IVA Ret 10.6%',    'value' => '0.106',     'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 8,  'title' => 'IVA Ret 10%',      'value' => '0.1',       'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 9,  'title' => 'IVA Ret 9.19%',    'value' => '0.0919',    'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 10, 'title' => 'IVA Ret 8%',       'value' => '0.08',      'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 11, 'title' => 'IVA Ret 6%',       'value' => '0.06',      'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 12, 'title' => 'IVA Ret 5.4%',     'value' => '0.054',     'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 13, 'title' => 'IVA Ret 5.3333%',  'value' => '0.053333',  'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 14, 'title' => 'IVA Ret 5%',       'value' => '0.05',      'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 15, 'title' => 'IVA Ret 4%',       'value' => '0.04',      'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 16, 'title' => 'IVA Ret 3%',       'value' => '0.03',      'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 17, 'title' => 'IVA Ret 2.5%',     'value' => '0.025',     'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 18, 'title' => 'IVA Ret 2%',       'value' => '0.02',      'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 19, 'title' => 'IVA Ret 0.7%',     'value' => '0.007',     'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 20, 'title' => 'IVA Ret 0.5333%',  'value' => '0.005333',  'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 21, 'title' => 'IVA Ret 0.5%',     'value' => '0.005',     'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 22, 'title' => 'IVA Ret 0.2%',     'value' => '0.002',     'created_at' => '2023-01-19', 'feature' => true, 'status' => 1],
                                        ['id' => 23, 'title' => 'IVA Ret 0%',       'value' => '0',         'created_at' => '2023-01-19', 'feature' => true, 'status' => 1]
                                      ]
        ];
    }

    public function getCatalog($catalog) {
        return $this->catalogs[$catalog] ?? [];
    }
}